//////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2013 by Autodesk, Inc.  All rights reserved.
//
// This computer source code and related instructions and comments
// are the unpublished confidential and proprietary information of
// Autodesk, Inc. and are protected under applicable copyright and
// trade secret law.  They may not be disclosed to, copied or used
// by any third party without the prior written consent of Autodesk, Inc.
//
//////////////////////////////////////////////////////////////////////////////

$.Controller('SearchAddressMapController',
//static methods
    {
        ResultPanelState: { "collapsed": 0, "expanding": 1, "expanded": 2, "collapsing": 3 },

        // This function is meant to set the focus on the search address edit box such
        // that user can directly type in a location to search.
        focusAddress: function () {
            $('#address').focus();
        },
        handleKeyDownEvent: function (event) {
            //check if pop-up menu is visible - if it is visible, then we need to hide that pop-up menu when pressing ESC
            if ($('#addressSearchSection').controllers().length != 0) {
                var searchAddresscontroller = $('#addressSearchSection').controllers()[0];
                if (searchAddresscontroller.isPopUpMenuVisible()) {
                    if (event.keyCode == 27) { // ESC
                        searchAddresscontroller.hidePopUpMenu();
                        return true;
                    }
                }
            }
            return false;
        },
        isCloudSupported: function () {
            var args = { 'functionName': 'Ac_Geo.isCloudSupported',
                         'invokeAsCommand': false,
                         'functionParams': {} };

            var jsonStr = exec(JSON.stringify(args));
            var res = JSON.parse(jsonStr);

            return res.supported == 1;
        }
},
//instance methods
    {
    init: function () {
        this.element.html('template_address_search_with_map', {});
        this.mapSection = $('#map_section', this.element);

        if (MapServiceProvider.isMapLoaded() && IS_ONLINE_MODE) {
            this.mapServiceHandler = new MapServiceProvider(this.mapSection.attr("id"), this.initMapEventHandler(this));
        } else {
            //consider as offline mode here
            this.mapServiceHandler = null;
            $('#markerInfoAndListCS').marker_location({ mapServiceHandler: null });
        }
        this.mapPinResult = {};
        this.curPanelResultState = -1;
        this.switchResultPanelState();
		$('#popupmenu').pop_up_menu();
        $('#popupmenu').pop_up_menu().bind('click', this.contextMenuClick(this));
        $('#searchAddress').attr("disabled", true);
        $('#searchAddress').attr("tabIndex", -1);

        $('#address').keyup(function () {
            if ($(this).val() != '') {
                $('#searchAddress').attr("disabled", false);
                $('#searchAddress').removeAttr("tabIndex");
            } else {
                $('#searchAddress').attr("disabled", true);
                $('#searchAddress').attr("tabIndex", -1);
            }
        });

        var self = this;
        $('body').click(function () {
            self.hidePopUpMenu();
        });

        $('body').keyup(function (e) {
            if (e.keyCode === 27) {
                self.hidePopUpMenu();
            }
        });

        $('#addressLabel').html($.localize("ID_ADDRESS_LABEL", SELECTED_LANG));
        $('#useMapsButton').html($.localize("ID_USE_MAPS", SELECTED_LANG));

        if (!IS_ONLINE_MODE) {
            $('#address').addClass("offline");
            $('#address').attr("disabled", true);
            $('#searchAddress').attr("disabled", true);
            $('#map_section').addClass("offline");
            $('#offlineMsg').css("visibility", "visible");

            // disable sign in button if cloud not available
            if(!SearchAddressMapController.isCloudSupported()) {
                $('#useMapsButton').addClass('displayNone');
                $('#signInOfflineMsg1').addClass('displayNone');
                $('#signInOfflineMsg2').addClass('displayNone');
            }
        }
    },
    initMapEventHandler:  function (self) {
        return function () {
            self.mapRightClickHandler = self.mapServiceHandler.addHandler(self.mapServiceHandler.map, 'rightclick', self.showPopupMenu(self));
            self.mapViewChangeHandler = self.mapServiceHandler.addHandler(self.mapServiceHandler.map, 'viewchangestart', self.hidePopUpMenu);

            // show the current location(if exist) in the lat/long/elevation widgets
            self.populateCurrentLocation();
        };
    },
    populateCurrentLocation: function () {
        if ($('#markerInfoAndListCS').controllers().length != 0) {
            $('#markerInfoAndListCS').marker_location('destroy');
        }
        $('#markerInfoAndListCS').html(""); //destroy the old

        $('#markerInfoAndListCS').marker_location({ mapServiceHandler: this.mapServiceHandler });

        //populate the search field if there is any long/lat in query
        if (globalQueries.hasOwnProperty('lat') && globalQueries.hasOwnProperty('long')) {
            MarkerLocationController.location.latitude = parseFloat(globalQueries["lat"]);
            MarkerLocationController.location.longitude = parseFloat(globalQueries["long"]);
            $('#address').val(MarkerLocationController.location.latitude + "," + MarkerLocationController.location.longitude).change();
            $('#searchAddress').attr("disabled", false); ;
            this.searchAddress();
        } else {
            $('#address').val('').change();
            this.removeAllResults();
            $('#searchResult').append("<p style='color:grey;'>" + $.localize('ID_NO_SEARCH_RESULT', SELECTED_LANG) + "</p>");
            $('#searchResult').append("<p style='color:grey;'>" + $.localize('ID_MSG_GUIDE_RIGHT_CLICK', SELECTED_LANG) + "</p>");
            //force to collapse search panel
            if (this.curPanelResultState != SearchAddressMapController.ResultPanelState.collapsed &&
                this.curPanelResultState != SearchAddressMapController.ResultPanelState.collapsing) {
                this.toggleSearchResult();
            }
        }

        // Upon launch, focus should be within search. We do this only after bing map is initialized
        // because loading of the bing map appears to grap the focus.
        SearchAddressMapController.focusAddress();
    },
    destroy: function () {
        if (this.mapServiceHandler) {
            this.mapServiceHandler.destroy();
        }
        //destroy pop-up menu
        if ($('#popupmenu').controllers().length != 0) {
            $('#popupmenu').pop_up_menu().unbind();
            $('#popupmenu').pop_up_menu('destroy');
        }
        $('#popupmenu').html("");

        this._super();
    },
    isPopUpMenuVisible: function () {
        if ($('#popupmenu').controllers().length != 0) {
            var popUpController = $('#popupmenu').controllers()[0];
            return popUpController.isVisible();
        } else {
            return false;
        }
    },
    hidePopUpMenu: function () {
        $('#popupmenu').pop_up_menu("hide");
    },

    contextMenuClick: function (self) {
        return function (el) {
            var funcName = el.target.id;
            self.dropMarker();
            self.hidePopUpMenu();
            MarkerLocationController.enableNextButton();
        };
    },

    dropMarker: function () {
        $('#markerInfoAndListCS').marker_location("dropMarker", this.locRightClick);
    },

    showPopupMenu: function (self) {
        return function (e) {

            if (typeof e.target.tryPixelToLocation != 'function') return;

            //show context menu
            var x = e.pageX;
            var y = e.pageY;
            var txtDropOrMove;
            if (MarkerLocationController.location.latitude == null) {
                txtDropOrMove = $.localize("ID_USE_LOCATION", SELECTED_LANG);
            }
            else {
                txtDropOrMove = $.localize("ID_MOVE_MAKER", SELECTED_LANG); ;
            }

     		$('#popupmenu').pop_up_menu("show", x, y, txtDropOrMove);
            //get location of right click
            var point = self.mapServiceHandler.createPoint(e.getX(), e.getY());
            self.locRightClick = e.target.tryPixelToLocation(point);
        }
    },

    removeAllResults: function () {
        $('#searchResult').empty();
    },
    searchNetworkErrorCallback: function (self) {
        return function (textStatus) {
            $('#loadingProgress').hide();
            //force to show panel
            if (self.curPanelResultState == SearchAddressMapController.ResultPanelState.collapsed) {
                self.toggleSearchResult();
            }
            //Show no result
            self.removeAllResults();
            var txt = $.localize("ID_NETWORK_ERROR", SELECTED_LANG);
            $('#resultheader').hide();
            var errorHtml = $('<span>' + txt + '<span>');
            $('#searchResult').append(errorHtml);
        };
    },
    populateSearchResult: function (self) {
        return function (result) {
            $('#loadingProgress').hide();
            //force to show panel
            if (self.curPanelResultState == SearchAddressMapController.ResultPanelState.collapsed) {
                self.toggleSearchResult();
            }

            if (!result || !result.resourceSets || result.resourceSets.length == 0 ||
                    !result.resourceSets[0].resources || result.resourceSets[0].resources.length == 0) {
                //Show no result
                var txt = $.localize("ID_NO_RESULT_FOUND", SELECTED_LANG);
                $('#resultheader').hide();
                var errorHtml = $('<span>' + txt + '<span>');
                $('#searchResult').append(errorHtml);
                return;
            }

            var resources = result.resourceSets[0].resources;
            $('.result_row').remove();
            var j = 0;
            var resultHeaderTxt = $.localize("ID_FOUND_RESULTS", SELECTED_LANG);
            resultHeaderTxt = resultHeaderTxt.replace("%d", resources.length);
            $('#resultheader').text(resultHeaderTxt);
            $('#searchResult').append("<p style='color:grey;'>" + $.localize('ID_MSG_SEARCH_HINT', SELECTED_LANG) + "</p>");

            //for(var v = 0; v < 5 * resources.length; ++v) {
            for (var i = 0; i < resources.length; ++i) {
                //var i = v % resources.length;

                var resource = resources[i];
                if (!resource.name) continue;

                ++j;
                var resultObj = { id: j, name: resource.name, fullname: MapServiceProvider.getFullAddress(resource) };
                var htmlTemplate = $($.View("result_row", resultObj));
                $('#searchResult').append(htmlTemplate);
                htmlTemplate.pin_row({ id: j, resource: resources[i], mapServiceHandler: self.mapServiceHandler });

                if (1 == j) {
                    htmlTemplate.addClass("active");
                    htmlTemplate.find('#useLocation').show();
                    htmlTemplate.pin_row("panToPin");
                }
            }
        }
    },
    switchResultPanelState: function () {
        this.curPanelResultState = (this.curPanelResultState + 1) % 4;
        switch (this.curPanelResultState) {
            case SearchAddressMapController.ResultPanelState.collapsed:
                $('#searchResultContainer').css('left', -Math.abs($('#searchResultContainer').outerWidth()));
                $('#hidePanel').hide();
                $("#expandPanel").show();
                break;
            case SearchAddressMapController.ResultPanelState.collapsing:
                $("#expandPanel").hide();
                $('#hidePanel').show();
                break;
            case SearchAddressMapController.ResultPanelState.expanding:
                $("#expandPanel").hide();
                $('#hidePanel').show();
                break;
            case SearchAddressMapController.ResultPanelState.expanded:
                $('#searchResultContainer').css('left', 0);
                $('#hidePanel').show();

                break;
        }
    },
    toggleSearchResult: function () {
        var $s = $('#searchResultContainer');
        this.switchResultPanelState();
        (function (self) {
            $s.animate(
            //properties animate
                    {
                    left: parseInt($s.css('left'), 10) == 0 ? -$s.outerWidth() : 0
                },
            //options of animate
                    {
                    complete: function () {
                        self.switchResultPanelState();
                        if (parseInt($s.css('left'), 10) != 0) {
                            //self.mapSection.css('left', 0);
                            $('.spanright').css('margin-left', 0);
                        }
                        else {
                            //self.mapSection.css('left', $s.outerWidth());
                            $('.spanright').css('margin-left', $s.outerWidth());
                        }
                    },
                    duration: 700,
                    step: function (now, fx) {
                        var movingLeft = 250 + now;
                        //self.mapSection.css('left', movingLeft);
                        $('.spanright').css('margin-left', movingLeft);
                        $('#hidePanel').css('left', movingLeft);
                    }
                }//end of options of animate
                ) //end animate
        })(this);
    },

    searchAddress: function () {
        var queryStr = $('#address').val();
        var maxResultShow = 20;
        this.removeAllResults();
        $("#searchResult").append('<li class="nav-header" id="resultheader">' + $.localize("ID_SEARCH_INPROGRESS", SELECTED_LANG) + '</li>');
        $("#searchResult").append('<li class="nav-header" style="left:20px;" id="loadingProgress"><img src="./assets/icon/ajax-loader.gif"/></li>');
        this.mapServiceHandler.queryLocation(queryStr, maxResultShow, this.populateSearchResult(this), this.searchNetworkErrorCallback(this));
    },
    '#address keypress': function (el, ev) {
        var $addressTxt = $('#address');
        if ($addressTxt.val()) {
            if (event.which == 13) {
                event.preventDefault();
                this.searchAddress();
            }
        }

    },
    "#searchAddress click": function (el, ev) {
        this.searchAddress();
    },
    '#hidePanel click': function (el, ev) {
        this.toggleSearchResult();
    },
    '#expandPanel click': function (el, ev) {
        if (IS_ONLINE_MODE) {
            this.toggleSearchResult();
        }
    },
    "#panthere click": function (el, ev) {
        $('#markerInfoAndListCS').marker_location('panThere');
    },
    "#TermsLink click": function (el, ev) {
        MarkerLocationController.geoLocationMapDlgInvokeTermsLink();
    },
    "#useMapsButton click": function (el, ev) {
        CAN_CANCEL = false;
        
        var args = { 'functionName': 'Ac_Geo.forceUseMap',
                'invokeAsCommand': false,
                'functionParams': {}
            };

        var jsonStr = exec(JSON.stringify(args));
        var res = JSON.parse(jsonStr);

        if(res.canUseMap) {
            IS_ONLINE_MODE = true;
            globalQueries['force_offline'] = "0";

            refreshDialog();
        }
        else {
            CAN_CANCEL = true;
        }
    }
});


// SIG // Begin signature block
// SIG // MIIZNgYJKoZIhvcNAQcCoIIZJzCCGSMCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFK5497K6TgXX
// SIG // PmOZr7dXxs65FycEoIIUMDCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIFhTCCBG2gAwIBAgIQKcFbP6rNUmpOZ708
// SIG // Tn4/8jANBgkqhkiG9w0BAQUFADCBtDELMAkGA1UEBhMC
// SIG // VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
// SIG // VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYD
// SIG // VQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cu
// SIG // dmVyaXNpZ24uY29tL3JwYSAoYykxMDEuMCwGA1UEAxMl
// SIG // VmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAx
// SIG // MCBDQTAeFw0xMjA3MjUwMDAwMDBaFw0xNTA5MjAyMzU5
// SIG // NTlaMIHIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2Fs
// SIG // aWZvcm5pYTETMBEGA1UEBxMKU2FuIFJhZmFlbDEWMBQG
// SIG // A1UEChQNQXV0b2Rlc2ssIEluYzE+MDwGA1UECxM1RGln
// SIG // aXRhbCBJRCBDbGFzcyAzIC0gTWljcm9zb2Z0IFNvZnR3
// SIG // YXJlIFZhbGlkYXRpb24gdjIxHzAdBgNVBAsUFkRlc2ln
// SIG // biBTb2x1dGlvbnMgR3JvdXAxFjAUBgNVBAMUDUF1dG9k
// SIG // ZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCoYmDrmd0Gq8ezSsDlfgaJFEFplNPNhWzM
// SIG // 2uFQaYAB/ggpQ11+N4B6ao+TqrNIWDIqt3JKhaU889nx
// SIG // l/7teWGwuOurstI2Z0bEDhXiXam/bicK2HVLyntliQ+6
// SIG // tT+nlgfN8tgB2NzM0BpE1YCnU2b6DwQw4V7BV+/F//83
// SIG // yGFOpePlumzXxNw9EKWkaq81slmmTxf7UxZgP9PGbLw8
// SIG // gLAPk4PTJI97+5BBqhkLb1YqSfWn3PNMfsNKhw/VwAN0
// SIG // dRKeM6H8SkOdz+osr+NyH86lsKQuics4fwK5uFSHQHsI
// SIG // t6Z0tqWvminRqceUi9ugRlGryh9X1ZqCqfL/ggdzYa3Z
// SIG // AgMBAAGjggF7MIIBdzAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDBABgNVHR8EOTA3MDWgM6Axhi9odHRwOi8v
// SIG // Y3NjMy0yMDEwLWNybC52ZXJpc2lnbi5jb20vQ1NDMy0y
// SIG // MDEwLmNybDBEBgNVHSAEPTA7MDkGC2CGSAGG+EUBBxcD
// SIG // MCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9ycGEwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // cQYIKwYBBQUHAQEEZTBjMCQGCCsGAQUFBzABhhhodHRw
// SIG // Oi8vb2NzcC52ZXJpc2lnbi5jb20wOwYIKwYBBQUHMAKG
// SIG // L2h0dHA6Ly9jc2MzLTIwMTAtYWlhLnZlcmlzaWduLmNv
// SIG // bS9DU0MzLTIwMTAuY2VyMB8GA1UdIwQYMBaAFM+Zqep7
// SIG // JvRLyY6P1/AFJu/j0qedMBEGCWCGSAGG+EIBAQQEAwIE
// SIG // EDAWBgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG
// SIG // 9w0BAQUFAAOCAQEA2OkGvuiY7TyI6yVTQAYmTO+MpOFG
// SIG // C8MflHSbofJiuLxrS1KXbkzsAPFPPsU1ouftFhsXFtDQ
// SIG // 8rMTq/jwugTpbJUREV0buEkLl8AKRhYQTKBKg1I/puBv
// SIG // bkJocDE0pRwtBz3xSlXXEwyYPcbCOnrM3OZ5bKx1Qiii
// SIG // vixlcGWhO3ws904ssutPFf4mV5PDi3U2Yp1HgbBK/Um/
// SIG // FLr6YAYeZaA8KY1CfQEisF3UKTwm72d7S+fJf++SOGea
// SIG // K0kumehVcbavQJTOVebuZ9V+qU0nk1lMrqve9BnQK69B
// SIG // QqNZu77vCO0wm81cfynAxkOYKZG3idY47qPJOgXKkwmI
// SIG // 2+92ozCCBgowggTyoAMCAQICEFIA5aolVvwahu2WydRL
// SIG // M8cwDQYJKoZIhvcNAQEFBQAwgcoxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE6MDgGA1UE
// SIG // CxMxKGMpIDIwMDYgVmVyaVNpZ24sIEluYy4gLSBGb3Ig
// SIG // YXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVy
// SIG // aVNpZ24gQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0
// SIG // aWZpY2F0aW9uIEF1dGhvcml0eSAtIEc1MB4XDTEwMDIw
// SIG // ODAwMDAwMFoXDTIwMDIwNzIzNTk1OVowgbQxCzAJBgNV
// SIG // BAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEf
// SIG // MB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7
// SIG // MDkGA1UECxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8v
// SIG // d3d3LnZlcmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNV
// SIG // BAMTJVZlcmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5n
// SIG // IDIwMTAgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQD1I0tepdeKuzLp1Ff37+THJn6tGZj+qJ19
// SIG // lPY2axDXdYEwfwRof8srdR7NHQiM32mUpzejnHuA4Jnh
// SIG // 7jdNX847FO6G1ND1JzW8JQs4p4xjnRejCKWrsPvNamKC
// SIG // TNUh2hvZ8eOEO4oqT4VbkAFPyad2EH8nA3y+rn59wd35
// SIG // BbwbSJxp58CkPDxBAD7fluXF5JRx1lUBxwAmSkA8taEm
// SIG // qQynbYCOkCV7z78/HOsvlvrlh3fGtVayejtUMFMb32I0
// SIG // /x7R9FqTKIXlTBdOflv9pJOZf9/N76R17+8V9kfn+Bly
// SIG // 2C40Gqa0p0x+vbtPDD1X8TDWpjaO1oB21xkupc1+NC2J
// SIG // AgMBAAGjggH+MIIB+jASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MHAGA1UdIARpMGcwZQYLYIZIAYb4RQEHFwMwVjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L2NwczAqBggrBgEFBQcCAjAeGhxodHRwczovL3d3dy52
// SIG // ZXJpc2lnbi5jb20vcnBhMA4GA1UdDwEB/wQEAwIBBjBt
// SIG // BggrBgEFBQcBDARhMF+hXaBbMFkwVzBVFglpbWFnZS9n
// SIG // aWYwITAfMAcGBSsOAwIaBBSP5dMahqyNjmvDz4Bq1EgY
// SIG // LHsZLjAlFiNodHRwOi8vbG9nby52ZXJpc2lnbi5jb20v
// SIG // dnNsb2dvLmdpZjA0BgNVHR8ELTArMCmgJ6AlhiNodHRw
// SIG // Oi8vY3JsLnZlcmlzaWduLmNvbS9wY2EzLWc1LmNybDA0
// SIG // BggrBgEFBQcBAQQoMCYwJAYIKwYBBQUHMAGGGGh0dHA6
// SIG // Ly9vY3NwLnZlcmlzaWduLmNvbTAdBgNVHSUEFjAUBggr
// SIG // BgEFBQcDAgYIKwYBBQUHAwMwKAYDVR0RBCEwH6QdMBsx
// SIG // GTAXBgNVBAMTEFZlcmlTaWduTVBLSS0yLTgwHQYDVR0O
// SIG // BBYEFM+Zqep7JvRLyY6P1/AFJu/j0qedMB8GA1UdIwQY
// SIG // MBaAFH/TZafC3ey78DAJ80M5+gKvMzEzMA0GCSqGSIb3
// SIG // DQEBBQUAA4IBAQBWIuY0pMRhy0i5Aa1WqGQP2YyRxLvM
// SIG // DOWteqAif99HOEotbNF/cRp87HCpsfBP5A8MU/oVXv50
// SIG // mEkkhYEmHJEUR7BMY4y7oTTUxkXoDYUmcwPQqYxkbdxx
// SIG // kuZFBWAVWVE5/FgUa/7UpO15awgMQXLnNyIGCb4j6T9E
// SIG // mh7pYZ3MsZBc/D3SjaxCPWU21LQ9QCiPmxDPIybMSyDL
// SIG // kB9djEw0yjzY5TfWb6UgvTTrJtmuDefFmvehtCGRM2+G
// SIG // 6Fi7JXx0Dlj+dRtjP84xfJuPG5aexVN2hFucrZH6rO2T
// SIG // ul3IIVPCglNjrxINUIcRGz1UUpaKLJw9khoImgUux5Ol
// SIG // SJHTMYIEcjCCBG4CAQEwgckwgbQxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7MDkGA1UE
// SIG // CxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZl
// SIG // cmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNVBAMTJVZl
// SIG // cmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5nIDIwMTAg
// SIG // Q0ECECnBWz+qzVJqTme9PE5+P/IwCQYFKw4DAhoFAKBw
// SIG // MBAGCisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBT62jOPUzYM
// SIG // Sfr/PM/W/M6LaXWekzANBgkqhkiG9w0BAQEFAASCAQB8
// SIG // uohJyhFAD3+8zshmJcSQNbqmzpE4C8D6IulkUeDTDHvm
// SIG // 3S5Jytf5G7SG26Fy+yf4MAcoXmA915/k2qXk9SGQdS+f
// SIG // 81w41P1/EFhxY19qCv5+VMj/T9ZywPrP3T6TidcpZjvJ
// SIG // 2u2zXt2gxJiHdhvUJWoXos67E2k4ARXQ8mgHHNVkB3lU
// SIG // qZj+GIAfY7y8Awaq1JBN46KOaspwVRr3tGsSz11+sGiC
// SIG // wvcSqdtl1Nmlcpsv9pBV15YlCESI46Q219xF1j+NgaNs
// SIG // fhSSZfAz5oQ9Cx6AzrE78XBQC8HgDob6YuHFPFvr3kWs
// SIG // 31ND8MgONIL+71YBPvFEwpIU7ZtSn8pMoYICCzCCAgcG
// SIG // CSqGSIb3DQEJBjGCAfgwggH0AgEBMHIwXjELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMTAwLgYDVQQDEydTeW1hbnRlYyBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBIC0gRzICEA7P9DjI/r81bgTY
// SIG // apgbGlAwCQYFKw4DAhoFAKBdMBgGCSqGSIb3DQEJAzEL
// SIG // BgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTE0MDIw
// SIG // NzExMTQxMlowIwYJKoZIhvcNAQkEMRYEFO1fIzPF6ITC
// SIG // FQGJOKwNj5nQQliyMA0GCSqGSIb3DQEBAQUABIIBABD3
// SIG // EPPK3wQU5YgX//O8BOsPIJf3eeOa61mHsWMd0E4lZ70Z
// SIG // G9HyIJr0xlC5HPVXkQ75krX7C8whZWoha82z7YhlnZ7K
// SIG // Vg+6ddQxplahSqUdXdb/tA8HDkaEV5bvavpkij4Kwsn4
// SIG // 9DxJsZZr1JR4zCMSQIrF+ggElegxreECxfNlBZShlxZd
// SIG // DhMB72CXP3su9umxoy/LM0cWo667rj8dDLeyoipiqs4d
// SIG // OlSGRKpjRCSChUvXOjjxgT4x5dJD631iIzHTedpgdOm0
// SIG // 8z7fpyRW02nHWRgYlHaUb6udCroTO9lr+Edx4crzVdDr
// SIG // nLVbKlWxQ2m5rjIYjmCpvH/hHHIHtt8=
// SIG // End signature block
